/*
 * Parts of a Sparc instruction
 */
#define	OP0_MASK	0xFFFFFFFF
#define	OP1_MASK	0xC0000000
#define	OP2A_MASK	0xC1C00000
#define	OP2B_MASK	0xDFC00000
#define	OP3A_MASK	0xC1F80000
#define	OP3B_MASK	0xC1F83FE0
#define	OP3C_MASK	0xDFF80000

#define	DISP30_MASK	0x3FFFFFFF
#define	DISP22_MASK	0x003FFFFF
#define	IMM22_MASK	0x003FFFFF
#define	SIMM13_MASK	0x00001FFF
#define	SIMM13_FIELD(i)	(((i) & 0x1000) ? (((i)&SIMM13_MASK)|~SIMM13_MASK) \
					: ((i)&SIMM13_MASK))
#define	RD_MASK		0x3E000000
#define	RD_SHIFT	25
#define	RD_FIELD(i)	(((i) & RD_MASK) >> RD_SHIFT)
#define	RS1_MASK	0x0007C000
#define	RS1_SHIFT	14
#define	RS1_FIELD(i)	(((i) & RS1_MASK) >> RS1_SHIFT)
#define	RS2_MASK	0x0000001F
#define	RS2_FIELD(i)	((i) & RS2_MASK)
#define	ASI_MASK	0x00001FE0
#define	ASI_SHIFT	5
#define	ASI_FIELD(i)	(((i) & ASI_MASK) >> ASI_SHIFT)
#define	RSPEC_MASK	0x00180000
#define	RSPEC_SHIFT	19
#define	RSPEC_FIELD(i)	(((i) & RSPEC_MASK) >> RSPEC_SHIFT)
#define	I_BIT		0x00002000
#define	ANNUL_BIT	0x20000000

/*
 * Arguments types
 */
#define	ARG_SHIFT(i)	((i) << 2)
#define	ARG_MASK	0xF
#define	ARG_DISP30	0x1
#define	ARG_RD		0x2
#define	ARG_RS1		0x3
#define	ARG_RS2		0x4
#define	ARG_IMM22	0x5
#define	ARG_DISP22	0x6
#define	ARG_SIMM13	0x7
#define	ARG_RSPEC	0x8	/* Special Register */
#define	ARG_REGSR	0x9
#define	ARG_REGQ	0xA
#define	ARG_ASI		0xD	/* [regaddr]asi */
#define	ARG_IRI		0xE	/* reg_or_imm */
#define	ARG_ISL		0xF	/* [address] or address */
#define	ARG_NO(i,x)	((x) << ARG_SHIFT(i))

/*
 * Flags
 */
#define	FLAG_ANNUL	0x01
#define	FLAG_NOBRAC	0x02
#define	FLAG_FLTREG	0x04
#define	FLAG_CPREG	0x08

struct sparcoptab {
	char	*opname;
	long	opcode;
	long	opmask;
	long	args;
	long	flags;
};

class SparcAsm : public Asm {
public:
	char	*literaldelimiter();
	Instr	*newInstr(long);
		SparcAsm(Core*);
};

class SparcInstr : public Instr {
	long		opword;
	long		args;
	sparcoptab	*tab;
public:
	char		*regarg(char*, long);
	char		*arg(int);
	char		*mnemonic();
	int		argtype(int);
	int		nargs();
			SparcInstr(Asm*, long);
};
